package org.msh.tb.client.shared.model;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;

/**
 * Generated by the server side and sent to the client with data about
 * the indicator table report
 *
 * @author Ricardo Memoria
 *
 */
public class CIndicatorResponse implements IsSerializable {

    /**
     * List of the top level columns
     */
    private ArrayList<CTableColumn> columns;

    /**
     * Number of levels in the column
     */
    private int columnLevels;

    /**
     * List of the rows with tile and its values
     */
    private ArrayList<CTableRow> rows;

    /**
     * Index of the variables used in the columns
     */
    private int[] colVarIndex;

    /**
     * Error message in case the report is not properly generated
     */
    private String errorMessage;

    /**
     * Indicate if the table must contain a last row with the
     * sum of each column, i.e, the total row
     */
    private boolean rowTotalAvailable;

    /**
     * Indicate if the table must contain a last column with the
     * sum of each cell in the row, i.e, the total column
     */
    private boolean colTotalAvailable;

    /**
     * The unit label used to measure the numbers in the table
     */
    private String unitTypeLabel;



    /**
     * @return the rows
     */
    public ArrayList<CTableRow> getRows() {
        return rows;
    }

    /**
     * @param rows the rows to set
     */
    public void setRows(ArrayList<CTableRow> rows) {
        this.rows = rows;
    }

    /**
     * @return the columns
     */
    public ArrayList<CTableColumn> getColumns() {
        return columns;
    }

    /**
     * @param columns the columns to set
     */
    public void setColumns(ArrayList<CTableColumn> columns) {
        this.columns = columns;
    }

    /**
     * @return the colVarIndex
     */
    public int[] getColVarIndex() {
        return colVarIndex;
    }

    /**
     * @param colVarIndex the colVarIndex to set
     */
    public void setColVarIndex(int[] colVarIndex) {
        this.colVarIndex = colVarIndex;
    }

    /**
     * @return the errorMessage
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * @param errorMessage the errorMessage to set
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * @return the rowTotalAvailable
     */
    public boolean isRowTotalAvailable() {
        return rowTotalAvailable;
    }

    /**
     * @param rowTotalAvailable the rowTotalAvailable to set
     */
    public void setRowTotalAvailable(boolean rowTotalAvailable) {
        this.rowTotalAvailable = rowTotalAvailable;
    }

    /**
     * @return the colTotalAvailable
     */
    public boolean isColTotalAvailable() {
        return colTotalAvailable;
    }

    /**
     * @param colTotalAvailable the colTotalAvailable to set
     */
    public void setColTotalAvailable(boolean colTotalAvailable) {
        this.colTotalAvailable = colTotalAvailable;
    }

    /**
     * @return the unitTypeLabel
     */
    public String getUnitTypeLabel() {
        return unitTypeLabel;
    }

    /**
     * @param unitTypeLabel the unitTypeLabel to set
     */
    public void setUnitTypeLabel(String unitTypeLabel) {
        this.unitTypeLabel = unitTypeLabel;
    }

    public int getColumnLevels() {
        return columnLevels;
    }

    public void setColumnLevels(int columnLevels) {
        this.columnLevels = columnLevels;
    }
}
